<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <title>密码修改工具 - 易优CMS</title>
</head>

<body>
<?php
    error_reporting(E_ALL & ~E_NOTICE);
    header('Content-Type: text/html; charset=UTF-8');
    // 数据绝对路径
    defined('DATA_PATH') or define('DATA_PATH', __DIR__ . '/data/');
    // 运行缓存
    defined('RUNTIME_PATH') or define('RUNTIME_PATH', DATA_PATH . 'runtime/');
    // 安装程序定义
    defined('DEFAULT_INSTALL_DATE') or define('DEFAULT_INSTALL_DATE',1525756440);
    // 序列号
    defined('DEFAULT_SERIALNUMBER') or define('DEFAULT_SERIALNUMBER','20180508131400oCWIoa');
    // 定义应用目录
    defined('APP_PATH') or define('APP_PATH', __DIR__ . '/application/');
    defined('EXT') or define('EXT', '.php');
    defined('DS') or define('DS', DIRECTORY_SEPARATOR);
    defined('THINK_PATH') or define('THINK_PATH', __DIR__ . DS);
    defined('CACHE_PATH') or define('CACHE_PATH', RUNTIME_PATH . 'cache' . DS);
    defined('ROOT_PATH') or define('ROOT_PATH', dirname(realpath(APP_PATH)) . DS);
    // 插件目录
    defined('WEAPP_DIR_NAME') or define('WEAPP_DIR_NAME', 'weapp');
    defined('WEAPP_PATH') or define('WEAPP_PATH', ROOT_PATH . WEAPP_DIR_NAME . DS);

    $version = getCmsVersion(); // 系统版本号
    $database = include_once "application/database.php";
    $dbHost = trim($database['hostname']);
    $dbport = $database['hostport'] ? $database['hostport'] : '3306';
    $dbName = trim($database['database']);
    $dbUser = trim($database['username']);
    $dbPwd = trim($database['password']);
    $dbPrefix = empty($database['prefix']) ? 'ey_' : trim($database['prefix']);
    $charset = trim($database['charset']);

    $conn = @mysqli_connect($dbHost, $dbUser, $dbPwd,$dbName,$dbport);
    if (mysqli_connect_error()){
        $msg = "连接数据库失败!".mysqli_connect_error($conn);
        tips($msg);
    }
    mysqli_set_charset($conn, $charset);

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {

        $type = $_POST['type'];
        if (1 == $type) { // 修改后台登录密码
            $user_name = $_POST['user_name'];
            $password = $_POST['password'];
            if (empty($password)) {
                tips("新密码不能为空！");
            }

            $config = include_once "application/config.php";
            $auth_code = $config['AUTH_CODE'];
            $sql = "SELECT value FROM `{$dbPrefix}config` WHERE name = 'system_auth_code' AND inc_type='system' ORDER BY id ASC LIMIT 1";
            $ret = mysqli_query($conn,$sql);
            while($row = mysqli_fetch_array($ret))
            {
                if (!empty($row['value'])) {
                    $auth_code = $row['value'];
                }
            }

            if (version_compare($version,'v1.5.7','<')) {
                $password = md5($auth_code.$password);
            } else {
                $entry = pwd_encry_type('bcrypt');
                if ('bcrypt' == $entry) {
                    $main_lang = 'cn';
                    $sql = "SELECT mark FROM `{$dbPrefix}language` ORDER BY id ASC LIMIT 1";
                    $ret = mysqli_query($conn,$sql);
                    while($row = mysqli_fetch_array($ret))
                    {
                        if (!empty($row['mark'])) {
                            $main_lang = $row['mark'];
                        }
                    }

                    $crypt_auth_code = '';
                    $sql = "SELECT value FROM `{$dbPrefix}config` WHERE name = 'system_crypt_auth_code' AND inc_type='system' AND lang='{$main_lang}' LIMIT 1";
                    $ret = mysqli_query($conn,$sql);
                    while($row = mysqli_fetch_array($ret))
                    {
                        if (!empty($row['value'])) {
                            $crypt_auth_code = $row['value'];
                        }
                    }
                    if (!empty($crypt_auth_code)) {
                        $password = crypt($password, $crypt_auth_code);
                    } else {
                        $password = md5($auth_code.$password);
                    }
                } else {
                    $password = md5($auth_code.$password);
                }
            }

            $sql = "UPDATE `{$dbPrefix}admin` SET `password`='{$password}' WHERE `user_name`='{$user_name}'";
            $ret = mysqli_query($conn,$sql);
            if ($ret) {
                $msg = "修改成功";
            } else {
                $msg = "修改失败，请官方客服！";
            }

            tips($msg);
        }
        else if (2 == $type) // 修改插件安装密码
        {
            $password = $_POST['password'];
            if (empty($password)) {
                tips("新密码不能为空！");
            }

            $config = include_once "application/config.php";
            $auth_code = $config['AUTH_CODE'];
            $sql = "SELECT value FROM `{$dbPrefix}config` WHERE name='system_auth_code' AND inc_type='system' ORDER BY id ASC LIMIT 1";
            $ret = mysqli_query($conn,$sql);
            while($row = mysqli_fetch_array($ret))
            {
                if (!empty($row['value'])) {
                    $auth_code = $row['value'];
                }
            }
            $password = md5($auth_code.$password);

            $t = time();
            $sql = "UPDATE `{$dbPrefix}config` SET `value`='{$password}', `update_time`='{$t}' WHERE `name`='weapp_installpwd' AND `inc_type`='weapp'";
            $ret = mysqli_query($conn,$sql);
            if ($ret) {
                delFile('./data/runtime/cache', true);
                $msg = "修改成功";
            } else {
                $msg = "修改失败，请官方客服！";
            }

            tips($msg);
        }
        else if (3 == $type) // 修改插件问题与答案
        {
            $ask = $_POST['ask'];
            if (empty($ask)) {
                tips("新问题不能为空！");
            }

            $answer = $_POST['answer'];
            if (empty($answer)) {
                tips("新答案不能为空！");
            }

            $config = include_once "application/config.php";
            $auth_code = $config['AUTH_CODE'];
            $sql = "SELECT value FROM `{$dbPrefix}config` WHERE name='system_auth_code' AND inc_type='system' ORDER BY id ASC LIMIT 1";
            $ret = mysqli_query($conn,$sql);
            while($row = mysqli_fetch_array($ret))
            {
                if (!empty($row['value'])) {
                    $auth_code = $row['value'];
                }
            }
            $answer = md5($auth_code.$answer);

            $t = time();
            $sql = "UPDATE `{$dbPrefix}setting` SET `value`='{$ask}', `update_time`='{$t}' WHERE `name`='weapp_install_ask' AND `inc_type`='weapp'";
            $sql2 = "UPDATE `{$dbPrefix}setting` SET `value`='{$answer}', `update_time`='{$t}' WHERE `name`='weapp_install_answer' AND `inc_type`='weapp'";
            if (@mysqli_query($conn,$sql) && @mysqli_query($conn,$sql2)) {
                delFile('./data/runtime/cache', true);
                $msg = "修改成功";
            } else {
                $msg = "修改失败，请官方客服！";
            }

            tips($msg);
        }
        else if (4 == $type) // 修改二次安全验证的答案
        {
            $answer = trim($_POST['answer']);
            if (empty($answer)) {
                tips("新答案不能为空！");
            }

            $config = include_once "application/config.php";
            $auth_code = $config['AUTH_CODE'];
            $sql = "SELECT value FROM `{$dbPrefix}config` WHERE name='system_auth_code' AND inc_type='system' ORDER BY id ASC LIMIT 1";
            $ret = mysqli_query($conn,$sql);
            while($row = mysqli_fetch_array($ret))
            {
                if (!empty($row['value'])) {
                    $auth_code = $row['value'];
                }
            }

            $entry = pwd_encry_type('bcrypt');
            if ('bcrypt' == $entry) {
                $crypt_auth_code = '';
                $sql = "SELECT value FROM `{$dbPrefix}config` WHERE name = 'system_crypt_auth_code' AND inc_type='system' ORDER BY id ASC LIMIT 1";
                $ret = mysqli_query($conn,$sql);
                while($row = mysqli_fetch_array($ret))
                {
                    if (!empty($row['value'])) {
                        $crypt_auth_code = $row['value'];
                    }
                }
                if (!empty($crypt_auth_code)) {
                    $answer = crypt($answer, $crypt_auth_code);
                } else {
                    $answer = md5($auth_code.$answer);
                }
            } else {
                $answer = md5($auth_code.$answer);
            }

            $t = time();
            $sql1 = "UPDATE `{$dbPrefix}setting` SET `value`='{$answer}', `update_time`='{$t}' WHERE `name`='security_answer' AND `inc_type`='security'";
            if (@mysqli_query($conn,$sql1)) {
                delFile('./data/runtime/cache', true);
                $msg = "修改成功";
            } else {
                $msg = "修改失败，请官方客服！";
            }

            tips($msg);
        }
        else if (5 == $type) // 修改后台登录锁定时间
        {
            $web_login_errexpire = intval($_POST['web_login_errexpire']);
            $t = time();
            $sql1 = "UPDATE `{$dbPrefix}config` SET `value`='{$web_login_errexpire}', `update_time`='{$t}' WHERE `name`='web_login_errexpire' AND `inc_type`='web'";
            if (@mysqli_query($conn,$sql1)) {
                delFile('./data/runtime/cache', true);
                $msg = "修改成功";
            } else {
                $msg = "修改失败，请官方客服！";
            }

            tips($msg);
        }
        else if (6 == $type) // 解除后台强制扫码登录
        {
            $data = [];
            $sql = "SELECT data FROM `{$dbPrefix}weapp` WHERE code = 'EyouGzhLogin' LIMIT 1";
            $ret = mysqli_query($conn,$sql);
            while($row = mysqli_fetch_array($ret))
            {
                if (!empty($row['data'])) {
                    $data = unserialize($row['data']);
                }
                break;
            }
            $data['gzh']['force'] = 0;
            $serdata = serialize($data);
            $sql1 = "UPDATE `{$dbPrefix}weapp` SET `data`='{$serdata}' WHERE `code`='EyouGzhLogin'";
            if (@mysqli_query($conn,$sql1)) {
                delFile('./data/runtime/cache', true);
                $msg = "解除成功";
            } else {
                $msg = "解除失败，请官方客服！";
            }

            tips($msg);
        }
        else if (7 == $type) // 后台登录异常
        {
            $sql = "DELETE FROM `{$dbPrefix}setting` WHERE `inc_type` = 'adminlogin'";
            if (@mysqli_query($conn,$sql)) {
                delFile('./data/runtime/cache', true);
                $msg = "修复成功";
            } else {
                $msg = "修复失败，请官方客服！";
            }

            tips($msg);
        }

    } else {
        /*管理员列表*/
        $sql = "SELECT * FROM `{$dbPrefix}admin`";
        $ret = mysqli_query($conn,$sql);
        $select_html = "";
        while($row = mysqli_fetch_array($ret))
        {
            $select_html .= "<option value='{$row['user_name']}'>{$row['user_name']}</option>";
        }
        /*end*/

        /*插件问题列表*/
        $weapp_askanswer_list = [];
        $sql = "SELECT value FROM `{$dbPrefix}setting` WHERE name='weapp_askanswer_list' AND inc_type='weapp' ORDER BY id ASC LIMIT 1";
        $ret = mysqli_query($conn,$sql);
        while($row = mysqli_fetch_array($ret))
        {
            if (!empty($row['value'])) {
                $weapp_askanswer_list = json_decode($row['value'], true);
            }
        }
        $ask_select_html = "";
        foreach ($weapp_askanswer_list as $key => $value) {
            $ask_select_html .= "<option value='{$key}'>{$value}</option>";
        }
        /*end*/

        /*二次安全验证的问题名称*/
        $security_ask = '';
        $sql = "SELECT value FROM `{$dbPrefix}setting` WHERE name = 'security_ask' AND inc_type='security' ORDER BY id ASC LIMIT 1";
        $ret = mysqli_query($conn,$sql);
        while($row = mysqli_fetch_array($ret))
        {
            if (!empty($row['value'])) {
                $security_ask = $row['value'];
            }
        }
        /*end*/
    }
    mysqli_close($conn);

    function tips($msg)
    {
        die('<script type="text/javascript">alert("'.$msg.'");window.location.href = "setpwd111.php";</script>');
    }

    /**
     * 获取CMS的版本号
     * @return [type] [description]
     */
    function getCmsVersion()
    {
        $version = 'v1.0.0';
        $version_txt_path = './data/conf/version.txt';
        if(file_exists($version_txt_path)) {
            $fp = fopen($version_txt_path, 'r');
            $content = fread($fp, filesize($version_txt_path));
            fclose($fp);
            $version = $content ? $content : $version;
        }
        return $version;
    }

    /**
     * 获取密码加密方式
     * @param  string $encry_pwd 
     * @return [type]            [description]
     */
    function pwd_encry_type($encry_pwd = '') {
        $entry = 'md5';
        if (32 != strlen($encry_pwd)) {
            if (defined('CRYPT_BLOWFISH') && CRYPT_BLOWFISH == 1) {
                $entry = 'bcrypt';
            }
        }

        return $entry;
    }

    /**
     * 递归删除文件夹
     *
     * @param string $path 目录路径
     * @param boolean $delDir 是否删除空目录
     * @return boolean
     */
    function delFile($path, $delDir = FALSE) {
        if(!is_dir($path))
            return FALSE;       
        $handle = @opendir($path);
        if ($handle) {
            while (false !== ( $item = readdir($handle) )) {
                if ($item != "." && $item != "..")
                    is_dir("$path/$item") ? delFile("$path/$item", $delDir) : @unlink("$path/$item");
            }
            closedir($handle);
            if ($delDir) {
                return @rmdir($path);
            }
        }else {
            if (file_exists($path)) {
                return @unlink($path);
            } else {
                return FALSE;
            }
        }
    }
?>
<style type="text/css">
    *,
    ::after,
    ::before {
        box-sizing: border-box;
    }

    .logo {
        width: 100%;
        text-align: center;
        margin: 100px 0 10px 0;
    }

    .logo img {
        text-align: center;
    }

    .info {
        padding: 10px 20px;
        font-size: 14px;
        text-align: center;
        position: fixed;
        top: 0;
        width: 100%;
        background: #f7f7f7;
    }

    .border {
        width: 100%;
        clear: both;
        border-bottom: 1px dashed #dedede;
    }

    .box {
        width: 400px;
        margin: 40px auto;
    }

    .name {
        font-size: 24px;
        text-align: center;
        margin-bottom: 20px;
        color: #666;
    }
    .tip {
        margin-top: 20px;
        font-size: 14px;
        color: #666;
        text-align: center;
    }
    .fexl {
        display: flex;
        align-items: center;
        margin-bottom: 20px;
    }

    .fexl .title {
        width: 75px;
        text-align: right;
        margin-right: 10px;
        font-size: 15px;
        color: #666;
    }

    .fexl .select {
        width: 308px;
        display: inline-block;
        position: relative;
        vertical-align: middle;
        padding: 0;
        overflow: hidden;
        cursor: pointer;
        color: #555;
        background-color: #fff;
        border: 1px solid #DCDFE6;
        text-shadow: none;
        border-radius: 4px;
        transition: box-shadow 0.25s ease;
        z-index: 2;
    }

    .fexl .select select {
        padding: 8px 10px;
        font-size: 15px;
        color: #606266;
        width: 100%;
        border: none;
        background: transparent;
        background-image: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        cursor: pointer;
    }

    .fexl .input input {
        width: 308px;
        height: 35px;
        display: inline-block;
        position: relative;
        vertical-align: middle;
        padding: 0 10px;
        overflow: hidden;
        font-size: 15px;
        color: #555;
        background-color: #fff;
        border: 1px solid #DCDFE6;
        text-shadow: none;
        border-radius: 4px;
        transition: box-shadow 0.25s ease;
        z-index: 2;
    }

    .fexl .input .time {
        width: 292px;

    }

    .submit {
        margin-top: 30px;
    }

    .submit input {
        display: block;
        color: #fff;
        text-align: center;
        margin: 0 auto;
        padding: 5px 10px;
        font-size: 16px;
        background: #ff6700;
        border: 1px solid #ff6700;
        border-radius: 4px;
        outline: 0;
        cursor: pointer;
    }

    .tab-container {
        width: 1200px;
        margin: 0 auto;
    }

    .tab-buttons {
        margin-top: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-bottom: 1px solid #e7e7e7;
    }

    .tab-button {
        padding: 15px 20px;
        font-size: 18px;
        cursor: pointer;
        border: none;
        background: none;
        position: relative;
    }

    .tab-button.active {
        background-color: #fff;
        color: #ff6700;
        font-weight: 700;
    }
    .tab-button:after {
        content: ' ';
        width: 0;
        height: 3px;
        background: #ff6700;
        display: block;
        z-index: 10;
        transition: width .1s ease-in-out;
        position: absolute;
        bottom: 0px;
        left: 50%;
        transform: translate(-50%, 0);
    }
    .tab-button.active:after, .tab-button:hover.active:after {
        width: 25px;
        background-color: #ff6700;
    }

    .tab-content {
        padding: 10px;
        display: none;
    }
    .tab-content.active{
        display: block;
    }
    .kefu {
        position: fixed;
        right: 10px;
        bottom: 120px;
        z-index: 100;
        width: 150px;
        height: 205px;
        background: #fff;
    }

    .kefu .wenben {
        padding: 0 16px;
    }

    .kefu .wenben p {
        margin: 0;
        text-align: center;
        color: #cd8941;
    }
</style>
<div class="logo">
    <img src="https://www.eyoucms.com/uploads/allimg/20220117/5-22011F92315649.png">
</div>

<br/>
<div class="info">
    <font style="color: red; font-size: 14px;">注意：修改完之后，建议删掉该文件，免得被其他人修改入侵！</font>
</div>
<div class="tab-container">
    <div class="tab-buttons">
      <button class="tab-button active" onclick="openTab(event, 'tab1')">忘记密码</button>
      <button class="tab-button" onclick="openTab(event, 'tab2')">忘记密保</button>
      <button class="tab-button" onclick="openTab(event, 'tab4')">重置锁定</button>
      <?php if (is_dir('./weapp/EyouGzhLogin/')) { ?>
      <button class="tab-button" onclick="openTab(event, 'tab5')">解除扫码</button>
      <?php } ?>
      <button class="tab-button" onclick="openTab(event, 'tab6')">登录异常</button>
    </div>

    <div id="tab1" class="tab-content active">
        <div class="box">
            <div class="name">后台登录密码重置</div>
            <form action="setpwd111.php" method="post">
                <div class="fexl">
                    <div class="title">用户名：</div>
                    <div class="select">
                        <select name="user_name">
                            <?php echo $select_html;?>
                        </select>
                    </div>
                </div>
                <div class="fexl">
                    <div class="title">新密码：</div>
                    <div class="input">
                        <input type="password" name="password" value="">
                    </div>
                </div>
                <input type="hidden" name="type" value="1">
                <div class="submit">
                    <input type="submit" name="submit" value="确认修改">
                </div>
            </form>
        </div>
    </div>

    <div id="tab2" class="tab-content">
    <?php if (version_compare($version,'v1.4.7','<')) { ?>
        <?php if (version_compare($version,'v1.4.2','>')) { ?>
            <div class="box">
                <div class="name">插件问题与答案重置</div>
                <form action="setpwd111.php" method="post">
                    <div class="fexl">
                        <div class="title">新问题：</div>
                        <div class="select">
                            <select name="ask">
                                <?php echo $ask_select_html;?>
                            </select>
                        </div>
                    </div>
                    <div class="fexl">
                        <div class="title">新答案：</div>
                        <div class="input">
                            <input type="text" name="answer" value="">
                        </div>
                    </div>
                    <input type="hidden" name="type" value="3">
                    <div class="submit">
                        <input type="submit" name="submit" value="确认修改">
                    </div>
                </form>
            </div>
        <?php } else { ?>
            <div class="box">
                <div class="name">插件安装密码重置</div>
                <form action="setpwd111.php" method="post">
                    <div class="fexl">
                        <div class="title">新密码：</div>
                        <div class="input">
                            <input type="password" name="password" value="">
                        </div>
                    </div>
                    <input type="hidden" name="type" value="2">
                    <div class="submit">
                        <input type="submit" name="submit" value="确认修改">
                    </div>
                </form>
            </div>
        <?php } ?>
    <?php } else if (version_compare($version,'v1.5.6','>')) { ?>
        <div class="box">
            <div class="name">密保问题重置</div>
            <form action="setpwd111.php" method="post">
                <div class="fexl">
                    <div class="title">问题名称：</div>
                    <div class="input">
                        <?php echo $security_ask;?>
                    </div>
                </div>
                <div class="fexl">
                    <div class="title">新的答案：</div>
                    <div class="input">
                        <input type="text" name="answer" value="">
                    </div>
                </div>
                <input type="hidden" name="type" value="4">
                <div class="submit">
                    <input type="submit" name="submit" value="确认修改">
                </div>
            </form>
        </div>
    <?php } ?>
    </div>

    <div id="tab4" class="tab-content">
        <?php if (version_compare($version,'v1.5.6','>')) { ?>
            <div class="box">
                <div class="name">后台登录锁定</div>
                <form action="setpwd111.php" method="post">
                    <div class="fexl">
                        <div class="title">锁定时间：</div>
                        <div class="input">
                            <input class="time" type="text" name="web_login_errexpire" value="" onkeyup="this.value=this.value.replace(/[^\d]/g,'');" onpaste="this.value=this.value.replace(/[^\d]/g,'')">&nbsp;<span style="color: #666;">秒</span>
                        </div>
                    </div>
                    <input type="hidden" name="type" value="5">
                    <div class="submit">
                        <input type="submit" name="submit" value="确认修改">
                    </div>
                </form>
            </div>
        <?php } ?>
    </div>
    <?php if (is_dir('./weapp/EyouGzhLogin/')) { ?>
    <div id="tab5" class="tab-content">
        <div class="box">
            <div class="name">解除后台强制扫码登录</div>
            <form action="setpwd111.php" method="post">
                <input type="hidden" name="type" value="6">
                <div class="submit">
                    <input type="submit" name="submit" value="确认解除">
                </div>
            </form>
        </div>
    </div>
    <?php } ?>
    <div id="tab6" class="tab-content">
        <div class="box">
            <div class="name">后台登录异常</div>
            <form action="setpwd111.php" method="post">
                <input type="hidden" name="type" value="7">
                <div class="submit">
                    <input type="submit" name="submit" value="确认修复">
                </div>
            </form>
            <div class="tip">修复后台登录空白弹窗,内存溢出异常提示</div>
        </div>
    </div>
</div>

<script>
    function openTab(evt, tabName) {
      // 隐藏所有标签页内容
      var tabContents = document.getElementsByClassName('tab-content');
      for (var i = 0; i < tabContents.length; i++) {
        tabContents[i].style.display = 'none';
      }

      // 移除所有按钮的 active 类
      var tabButtons = document.getElementsByClassName('tab-button');
      for (var j = 0; j < tabButtons.length; j++) {
        tabButtons[j].classList.remove('active');
      }

      // 显示当前选择的标签页内容并设置按钮为 active
      document.getElementById(tabName).style.display = 'block';
      evt.currentTarget.classList.add('active');
    }
  </script>
<div class="kefu">
    <img src="https://www.eyoucms.com/skin/images/eywx.jpg" style="width: 150px;">
    <div class="wenben">
        <p>扫码加微信客服</p>
        <p>进微信交流群</p>
    </div>
</div>
</body>
</html>